unit FTPFormUnit;
{
    UNIT FTPFormUnit
    Version number 1.0.

This unit contains pBoy's YAFTP main form and it's handling routines, the main
visual system core. Hardcore :)
* FTPFormTools added for separate form and it's other tool.

Created by Pter Karsai. }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ComCtrls, ToolWin, StdCtrls, Buttons, ExtCtrls, Grids, FileCtrl,
  FTPFormTools, FTPSession, FTPCacheManager, ImgList;

{ drX* (dialog reply) constants for determine user's selection }
const drTransfer       = 0; { user pressed 'Download'/'Upload' button }
      drAddToScheduler = 1; { user pressed 'Add to Scheduler' button }
      drResume         = 2; { user pressed 'Resume' button }
      drCancel         = 3; { user pressed 'Cancel' button or closed form }
      drDoIt           = 4; { symbolic: user asked to do operation }
      drNoButton       = 5; { user haven't pressed a button yet }

{ iiX* (image index) constants using icons in Local and RemoteList }
      iiNormalFolder   = 61; { normal folder icon index }
      iiParentFolder   = 12; { parent folder icon index }
      iiLinkFolder     = 63; { link folder icon index }
      iiLoadFolder     = 55; { loading folder icon index }
      iiFile           = 32; { file icon index }

type
  TFTPForm = class(TForm)
  { main menu }
    MainMenu: TMainMenu;
    FileM: TMenuItem; LoadSessionM : TMenuItem; SaveSessionM : TMenuItem;
    N1   : TMenuItem; QuitM        : TMenuItem; Help1        : TMenuItem;
    N2   : TMenuItem; PreferencesM : TMenuItem; GeneralHelpM : TMenuItem;
    N3   : TMenuItem; AboutM       : TMenuItem;
    NewSessionM: TMenuItem; SaveSessionAsM: TMenuItem; CreditzM: TMenuItem;
  { images }
    MainImages: TImageList;
  { toolbar items }
    ControlToolBar: TToolBar;
    TConnectionBar: TToolBar;
    Label1: TLabel; Label2: TLabel; Label3: TLabel; Label4: TLabel;
    Label5: TLabel; Label6: TLabel; Label7: TLabel; Label8: TLabel;
    SiteComboBox: TComboBox;
    UserNameEdit: TEdit; PasswordEdit: TEdit; PortEdit: TEdit;
    AnonLoginBox: TCheckBox;
    ToolButton1: TToolButton;  ToolButton2: TToolButton;
    ToolButton4: TToolButton;  ToolButton7: TToolButton;
    ToolButton10: TToolButton;
    CoolBar1: TCoolBar;
    ConnectB    : TToolButton; DisconnectB : TToolButton;  HelpB : TToolButton;
    ASCIIB      : TToolButton; BinaryB     : TToolButton;  AutoB : TToolButton;
    AboutB      : TToolButton;
    SaveSessionB  : TToolButton; NewSessionButton : TToolButton;
    StartSessionB : TToolButton; StopSessionB     : TToolButton;
    OpenSessionB  : TToolButton;
  { other items }
    CommArea: TRichEdit;
    Splitter1: TSplitter;  Splitter2: TSplitter; Splitter3: TSplitter;
    LocalList: TListView; RemoteList: TListView; SchedulerList: TListView;
    WaitTimer: TTimer;  NOOPTimer: TTimer;

  { popup menus }
    LocalPopup: TPopupMenu;
    RefreshLPM: TMenuItem;  N4: TMenuItem; CreateFolderLPM: TMenuItem;
    N5: TMenuItem; FileOpLPM: TMenuItem;  RemotePopup: TPopupMenu;
    RefreshRPM: TMenuItem;  N6: TMenuItem;  MainWindowHelpM: TMenuItem;
    HelpaboutPreferences1: TMenuItem;  HelponTransfer1: TMenuItem;
    RunFileLPM: TMenuItem;  DeleteFileLPM: TMenuItem;
    PrintFileLPM: TMenuItem;  N7: TMenuItem; StartExplorerLPM: TMenuItem;

  { others }
    Panel1: TPanel;
    LocalDrvCombo: TDriveComboBox;
    RemoteDirCombo: TComboBox;
    LocalDirCombo: TComboBox;


{------------------------------------------------------------------------------}
{ events ----------------------------------------------------------------------}
{------------------------------------------------------------------------------}
    procedure LocalListDblClick(Sender: TObject);
    procedure LocalDrvComboChange(Sender: TObject);
    procedure LocalListKeyPress(Sender: TObject; var Key: Char);
    procedure LocalDirComboChange(Sender: TObject);
    procedure DisconnectBClick(Sender: TObject);
    procedure PreferencesMClick(Sender: TObject);
    procedure QuitMClick(Sender: TObject);
    procedure ConnectBClick(Sender: TObject);
    procedure WaitTimerTimer(Sender: TObject);
    procedure AnonLoginBoxClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure HelpBClick(Sender: TObject);
    procedure RemoteListDblClick(Sender: TObject);
    procedure Splitter1Moved(Sender: TObject);
    procedure RemoteDirComboChange(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure SiteComboBoxKeyPress(Sender: TObject; var Key: Char);
    procedure FormShow(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure NOOPTimerTick(Sender: TObject);
    procedure AboutMClick(Sender: TObject);
    procedure AboutBClick(Sender: TObject);
    procedure RefreshLPMClick(Sender: TObject);
    procedure RefreshRPMClick(Sender: TObject);
    procedure CreateFolderLPMClick(Sender: TObject);
    procedure DeleteFileLPMClick(Sender: TObject);
    procedure LocalPopupPopup(Sender: TObject);
    procedure RemotePopupPopup(Sender: TObject);
    procedure RemoteListKeyPress(Sender: TObject; var Key: Char);
    procedure MainWindowHelpMClick(Sender: TObject);
    procedure GeneralHelpMClick(Sender: TObject);
    procedure CreditzMClick(Sender: TObject);
    procedure HelpaboutPreferences1Click(Sender: TObject);
    procedure HelponTransfer1Click(Sender: TObject);
    procedure AppException(Sender: TObject; E: Exception);
    procedure RunFileLPMClick(Sender: TObject);
    procedure PrintFileLPMClick(Sender: TObject);
    procedure StartExplorerLPMClick(Sender: TObject);
  public
    CacheDir   : string;
    LoggedIn   : boolean;
  { ShellExecute() Error Messages aren't fill range 0..32, but some of them are
    stored in the following table. }
    ShellErrorMsg: array[0..32] of string;

    { Public declarations }
  end;

var
  FTPForm     : TFTPForm;
  FTPFTools   : TFTPFormTools;

{------------------------------------------------------------------------------}

implementation

uses SetupFormUnit, TransferFormUnit, TransferRequestFormUnit,
     ResumeFormUnit, LogoFormUnit, AboutFormUnit, CreateFolderFormUnit;

{$R *.DFM}
{------------------------------------------------------------------------------}

procedure TFTPForm.LocalListDblClick(Sender: TObject);
var currentItem: TListItem;  { current selected item }
    currentDir : string;     { the current directory }
    dlgReply   : byte;       { dialog return code }
    itemFound  : TListItem;  { item found by FindCaption() }
begin
{ get current item }
    currentItem:= (Sender as TListView).ItemFocused;

{ if ain't no item, ain't no work - do our work if it's a folder item }
    if Assigned(currentItem) and (currentItem.ImageIndex in [iiParentFolder,
       iiNormalFolder]) then
    begin
    { cut last \ if length is 3 of current dir (i.e. c:\) }
       currentDir:= GetCurrentDir;
       if Length(currentDir) = 3 then SetLength(currentDir, 2);

    { do we go to upper directory ? }
       if (currentItem.ImageIndex = iiParentFolder) then
          SetCurrentDir(currentDir + '\..');

    { do we go down to a directory ? }
       if (currentItem.ImageIndex = iiNormalFolder) then
          SetCurrentDir(currentDir + '\' + currentItem.Caption);

    { refresh Local Browser }
       FTPFTools.RefreshLocalBrowser;
       Exit;
    end;

{ Sure, we clicked on a local file... or on NoMan's Land...
  Don't upload if no control connection alive or remote list is empty - if no
  'Parent Directory' entry, directory not accessible ! }
    if Assigned(currentItem) and (currentItem.ImageIndex = iiFile) and
       (FTPFTools.ControlConnected) and (RemoteList.Items.Count > 0 )then
    begin

    { is there a file with same name in RemoteList? }
        itemFound := RemoteList.FindCaption(0, currentItem.Caption, true, true,
                                            true);
    { if there's another file with same name... we can do Resume }
        if itemFound = nil then
        begin
           TransReqForm.ShowData(false, currentItem.Caption,
                               currentItem.SubItems[0], currentItem.SubItems[1],
                               FTPFTools.CurrentRemPath);
           dlgReply:= TransReqForm.RunDialog;
        end
        else
        begin
        { if local file bigger, enable Resuming }
           if (StrToInt(currentItem.SubItems[0]) >
               StrToInt(itemFound.SubItems[0])) and FTPFTools.CanResume
           then
              TransResForm.ResumeB.Enabled:= true
           else
              TransResForm.ResumeB.Enabled:= false;

        { run dialog }
           TransResForm.ShowLocalFile(currentItem.Caption,
                             currentItem.SubItems[0], currentItem.SubItems[1]);
           TransResForm.ShowRemoteFile(false, itemFound.Caption,
                                  itemFound.SubItems[0], itemFound.SubItems[1]);
           dlgReply:= TransResForm.RunDialog;
        end;

    { if we have to upload, just do it }
        if dlgReply = drTransfer then  { just simple download }
           FTPFTools.Upload(true, currentItem.Caption, '0', GetCurrentDir +
                            '\' + currentItem.Caption, currentItem.SubItems[0]);

        if dlgReply = drResume then    { use APPE }
           FTPFTools.Upload(false, currentItem.Caption, currentItem.SubItems[0],
                            GetCurrentDir + '\' + itemFound.Caption,
                            itemFound.SubItems[0]);
     end;
 end;

{------------------------------------------------------------------------------}

procedure TFTPForm.LocalDrvComboChange(Sender: TObject);
begin
{ change drive if it's required }
     if UpCase(GetCurrentDir[1]) <> UpCase(LocalDrvCombo.Drive) then
     begin
        SetCurrentDir(LocalDrvCombo.Drive + ':\');
        LocalDrvCombo.Drive:= GetCurrentDir[1];  { on fail }
     end;
{ refresh file view }
     FTPFTools.RefreshLocalBrowser;
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.LocalListKeyPress(Sender: TObject; var Key: Char);
begin
{ if ENTER pressed, call defined event handler onDblClick() }
     if Key = #13 then
        LocalListDblClick(Sender);
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.LocalDirComboChange(Sender: TObject);
begin
{ change drive if it's required }
     SetCurrentDir(LocalDirCombo.Items[LocalDirCombo.ItemIndex]);
     LocalDrvCombo.Drive:= GetCurrentDir[1];  { on fail }
{ refresh file view }
     FTPFTools.RefreshLocalBrowser;
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.DisconnectBClick(Sender: TObject);
begin
     LoggedIn:= false;
     NOOPTimer.Enabled:= false;
{ stop current operation }
     FTPFTools.CanContinue:= false;
     Application.ProcessMessages;

{ shut down connection - TFTPSession has built-in control for shutdown. }
     if Assigned(FTPFTools.XFTPSession) then
     begin
         FTPFTools.XFTPSession.Close;
         Application.ProcessMessages;
         FTPFTools.XFTPSession.Free;
         FTPFTools.XFTPSession:= nil;
         Application.ProcessMessages;
         CommArea.Clear;
         FTPFTools.AddToCommArea('>< Disconnected, ready for next connection.',
                                 caMisc)
     end;

{ shut down cache manager }
     if Assigned(FTPFTools.XFTPCache) then
     begin
         FTPFTools.XFTPCache.Free;
         FTPFTools.XFTPCache:= nil;
     end;

{ enable Connect button / disable Disconnect button / Preferences menu }
     FTPForm.ConnectB.Enabled:= true;
     FTPForm.DisconnectB.Enabled:= false;
     PreferencesM.Enabled:= true;

{ clear Remote Browser and Remote Folder History }
     RemoteList.Visible:= false;
     RemoteList.Items.Clear;
     RemoteList.Visible:= true;
     RemoteDirCombo.Items.Clear;
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.PreferencesMClick(Sender: TObject);
begin
{ don't let user to clickclickclickclick, just click to SetupForm !}
     FTPForm.Enabled:= false;
{ show Preferences }
     SetupForm.LoadData;  { load internal data to SetupForm }
     SetupForm.Show;
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.QuitMClick(Sender: TObject);
begin
    Close;  { onCloseQuery event handler will ask us... }
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.ConnectBClick(Sender: TObject);
begin
{ setup screen and VCL access }
     PreferencesM.Enabled:= false;  { don't let user to modify Preferences }
     CommArea.Clear; { clear CommArea }
     with RemoteList do begin Visible:= false; Items.Clear; Visible:= true end;
     NOOPTimer.Interval:= SetupForm.SetupData.sNOOPSecs * 1000;

{ if site entry doesn't exist, add it to SiteComboBox }
    if SiteComboBox.Items.IndexOf(SiteComboBox.Text) = -1 then
    begin
    { we let 32 site history... }
       if SiteComboBox.Items.Count >= 32 then SiteComboBox.Items.Delete(0);
       SiteComboBox.ItemIndex:= SiteComboBox.Items.Add(SiteComboBox.Text);
    end;

{ let Windows to execute changes (avoid re-press Connect }
    Application.ProcessMessages;

    with FTPFTools do begin
    { try to connect }
         ConnectToRemoteHost;
    { try to login }
         if CanContinue then Login;
    { try to determine resume state }
         if CanContinue then CanResume:= CanResumeDownloads;
    { if everything is allright, create FTP cache manager }
         if CanContinue then
            XFTPCache:= TFTPCache.Create(CacheDir, remoteSite,
                        SetupForm.SetupData.sExpDays);

    { load directory list }
         if CanContinue then LoadDir(false);
    end;

    if FTPFTools.CanContinue then LoggedIn:= true;
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.WaitTimerTimer(Sender: TObject);
begin
     FTPFTools.DelaySpent:= true;
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.AnonLoginBoxClick(Sender: TObject);
begin
    UserNameEdit.Enabled:= not UserNameEdit.Enabled;  { disable user name and }
    PasswordEdit.Enabled:= not PasswordEdit.Enabled;  { password if anonymous }
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.FormCreate(Sender: TObject);
var orgPath: string;  { original path }
          x: byte;    { cycle variable }
begin
{ bind non-standard highest level exception handler }
    Application.OnException:= AppException;

{ prepare ShellExecute() unspecified error messages by ShellAPI }
    for x:= 0 to 32 do
        ShellErrorMsg[x]:= 'An unspecified error occurred, code: ' +
                           IntToStr(x) + '.';

{ define known ShellExecute() error messages }
    ShellErrorMsg[0]:=  'The operating system is out of memory or resources.';
    ShellErrorMsg[2]:=  'The specified file was not found.';
    ShellErrorMsg[5]:=  'The operating system denied access to the specified ' +
                         'file.';
    ShellErrorMsg[8]:=  'There was not enough memory to complete the operation.';
    ShellErrorMsg[32]:= 'The specified dynamic-link library was not found.';
    ShellErrorMsg[26]:= 'A sharing violation occurred.';
    ShellErrorMsg[27]:= 'The filename association is incomplete or invalid.';
    ShellErrorMsg[28]:= 'The DDE transaction could not be completed because ' +
                        'the request timed out.';
    ShellErrorMsg[29]:= 'The DDE transaction failed.';
    ShellErrorMsg[30]:= 'The DDE transaction could not be completed because ' +
                        'other DDE transactions were being processed.';
    ShellErrorMsg[31]:= 'There is no application associated with the given ' +
                        'filename extension.';

{ instaning classes we need }
    FTPFTools:= TFTPFormTools.Create;

{ determine cache directory... }
    CacheDir:= ExtractFilePath(Application.EXEName) + 'cache\';
    Application.HelpFile:= ExtractFilePath(Application.EXEName) +
                                          'pYAFTPHelp.hlp';
    orgPath:= GetCurrentDir;
    try
       ChDir(CacheDir);
    except
       on EInOutError do MkDir(CacheDir);
    end;
    ChDir(orgPath);
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.HelpBClick(Sender: TObject);
begin
    Application.HelpCommand(HELP_FINDER, 0);
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.RemoteListDblClick(Sender: TObject);
var currentItem: TListItem;  { current selected item }
    currentDir : string;     { current remote directory  }
    cwdReply   : word;       { reply of ChangeWorkDir() }
    dlgReply   : byte;       { dialog reply }
    itemFound  : TListItem;  { i'm tired }
begin
{ get current item }
    currentItem:= (Sender as TListView).ItemFocused;

{ if there's no control connection, we don't do anything }
    if not FTPFTools.ControlConnected or not Assigned(currentItem) then exit;

{ if operation is in progress, show the user a message }
    if FTPFTools.XFTPSession.InSequence then
    begin
    { show message }
       FTPFTools.AddToCommArea('Operation is in progress, try later...',caMisc);
       exit;
    end;

{ if ain't no item, ain't no work - do our work if it's a folder item }
    if currentItem.ImageIndex in [iiNormalFolder, iiLinkFolder, iiParentFolder]
    then begin
       currentDir:= FTPFTools.CurrentRemPath;
       if Copy(currentDir, Length(currentDir) - 1, 1) = '/' then
          SetLength(currentDir, Length(CurrentDir) - 1);  { cut down last '/' }

    { do we go to upper directory ? aren't we at root?}
       if (currentItem.ImageIndex = iiParentFolder) then
       begin
       { show downloading... change remote folder image to LoadFolder }
          FTPForm.RemoteList.ItemFocused.ImageIndex:= iiLoadFolder;

       { if we're at root, we can't go up }
          if currentDir <> '' then
             cwdReply:= FTPFTools.XFTPSession.ChangeWorkDir(currentDir + '/../')
          else
             exit;
       end;

    { do we go down to a directory ? }
       if (currentItem.ImageIndex = iiNormalFolder) or
          (currentItem.ImageIndex = iiLinkFolder) then
       begin
       { show downloading... change remote folder image to LoadFolder }
          FTPForm.RemoteList.ItemFocused.ImageIndex:= iiLoadFolder;
          cwdReply:= FTPFTools.XFTPSession.ChangeWorkDir(currentDir +
                     '/' + currentItem.Caption + '/');
       end;

    { if there was an error...}
       if cwdReply <> smNO_ERROR then
       begin
          FTPFTools.AddToCommArea('ERROR   > Couldn''t enter directory: ' +
                                  smErrorDesc[cwdReply], caError);
          exit;
       end;

    { refresh directory list }
       FTPFTools.LoadDir(false);
       exit;
    end;

{ it's sure, we clicked on a file... or on  NoMan's Land.}
    if currentItem.ImageIndex = iiFile then
    begin
    { is there a file with same name in LocalList? }
        itemFound := LocalList.FindCaption(0, currentItem.Caption, true, true,
                                           true);
        if itemFound = nil then
        begin
        { run dialog }
           TransReqForm.ShowData(true, currentItem.Caption,
                              currentItem.SubItems[0], currentItem.SubItems[1],
                              GetCurrentDir);
           dlgReply:= TransReqForm.RunDialog
        end
        else
        begin
        { enable Resume button if filesize smaller on local side }
           if (StrToInt(currentItem.SubItems[0]) >
               StrToInt(itemFound.SubItems[0])) and FTPFTools.CanResume
           then
              TransResForm.ResumeB.Enabled:= true
           else
              TransResForm.ResumeB.Enabled:= false;

        { run dialog }
           TransResForm.ShowRemoteFile(true, currentItem.Caption,
                              currentItem.SubItems[0], currentItem.SubItems[1]);
           TransResForm.ShowLocalFile(itemFound.Caption, itemFound.SubItems[0],
                                       itemFound.SubItems[1]);
           dlgReply:= TransResForm.RunDialog;
        end;

    { if we have to download, just do it }
        if dlgReply = drTransfer then  { just simple download }
           FTPFTools.Download(true,currentItem.Caption, currentItem.SubItems[0],
                              GetCurrentDir + '\' + currentItem.Caption, '0');

        if dlgReply = drResume then   { resumed download }
           FTPFTools.Download(false, currentItem.Caption,
                              currentItem.SubItems[0], GetCurrentDir + '\' +
                              currentItem.Caption, itemFound.SubItems[0]);
     end;

end;

{------------------------------------------------------------------------------}

procedure TFTPForm.Splitter1Moved(Sender: TObject);
begin
{ resize RemoteDirCombo and LocalDirCombo as RemoteList and LocalList resized. }
    RemoteDirCombo.Left  := RemoteList.Left;
    RemoteDirCombo.Width := RemoteList.Width;
    LocalDirCombo.Width  := LocalList.Width - 104;
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.RemoteDirComboChange(Sender: TObject);
var cwdReply: byte;  { result of ChangeWorkDir }
begin
{ if we aren't connected, we can't change directory }
     if not FTPFTools.ControlConnected then exit;

{ if operation is in progress, show the user a message }
    if FTPFTools.XFTPSession.InSequence then
    begin
    { show message }
       FTPFTools.AddToCommArea('Operation is in progress, try later...',caMisc);
       exit;
    end;

{ change drive if it's required }
     SetCurrentDir(LocalDirCombo.Items[LocalDirCombo.ItemIndex]);
     cwdReply:= FTPFTools.XFTPSession.ChangeWorkDir(RemoteDirCombo.Items[
                                                    RemoteDirCombo.ItemIndex]);
{ if there was an error...}
     if cwdReply <> smNO_ERROR then
        FTPFTools.AddToCommArea('ERROR   > Couldn''t enter directory: ' +
                                smErrorDesc[cwdReply], caError);
{ refresh list }
     FTPFTools.LoadDir(false);
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.FormResize(Sender: TObject);
begin
{ resize LocalDirCombo - RemoteDirCombo }
    Splitter1Moved(Sender);
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.SiteComboBoxKeyPress(Sender: TObject; var Key: Char);
begin
{ if user hit Enter, we have to connect if we aren't connected... }
    if (Key = #13) and not FTPFTools.ControlConnected then
       ConnectBClick(Sender);
{ if user hit ESC, delete box's containing }
    if Key = #27 then SiteComboBox.Text:= '';
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.FormShow(Sender: TObject);
begin
{ show logo }
     LogoForm.Show;
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
const Msg: PChar = 'You are still connected. '#10'Do you really want to quit?';
var dlgReply: integer;
begin
{ ask user before quit when connected }
     if FTPFTools.ControlConnected then
        dlgReply:= Application.MessageBox(Msg, 'pBoy''s Yet Another FTP > Quit',
                              MB_YESNO + MB_ICONQUESTION);
{ if user chosed Yes, quit }
     if (dlgReply = IDYES) or not FTPFTools.ControlConnected then
     begin
        FTPFTools.SaveInitSettings;
        DisconnectBClick(Sender);
        CanClose:= true;
        LogoForm.Close;
     end
     else
        CanClose:= false;
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.NOOPTimerTick(Sender: TObject);
begin
{ do not send NOOP's if operations is in sequence }
    with FTPFTools do
         if not XFTPSession.InSequence and ControlConnected and CanContinue then
                XFTPSession.SendNOOP;
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.AboutMClick(Sender: TObject);
begin
    FTPForm.Enabled:= false;
    AboutForm.Show;
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.AboutBClick(Sender: TObject);
begin
    AboutMClick(Sender);
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.RefreshLPMClick(Sender: TObject);
begin
    FTPFTools.RefreshLocalBrowser;
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.RefreshRPMClick(Sender: TObject);
begin
{ refresh list if connected and still files in LocalList }
    if FTPFTools.ControlConnected and (LocalList.Items.Count > 0) then
       FTPFTools.LoadDir(true);
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.CreateFolderLPMClick(Sender: TObject);
const Msg: string = 'Couldn''t create folder: %s.'#10#10'Check path you typed!';
var folderName : string;
begin
{ run create form dialog }
    folderName:= CreateFolderForm.RunDialog;
{ create directory if it's possible }
    if folderName <> '' then
    begin
       try
          MkDir(folderName);
       except
          on E:EInOutError do Application.MessageBox(PChar(Format(Msg,
             [E.Message])), 'pBoy''s Yet Another FTP > Error',
             MB_OK + MB_ICONERROR)
       end;
    { refresh local }
       FTPFTools.RefreshLocalBrowser;
    end;
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.DeleteFileLPMClick(Sender: TObject);
const Msg: string = 'Do you really want to delete this file?';
      MsgErr: string = 'Error while attempting to delete file.';
var currentItem: TListItem;  { temporary list item }
    retAsk     : longint;
begin
    currentItem:= LocalList.ItemFocused;
{ ask user... }
    retAsk:= Application.MessageBox(PChar(Msg),'pBoy''s Yet Another FTP Client'+
                                    ' > Quit', MB_YESNO + MB_ICONQUESTION);
    if retAsk = IDYES then
    begin
    { try to delete }
        if not DeleteFile(GetCurrentDir + '\' + currentItem.Caption) then
           Application.MessageBox(PChar(MsgErr), 'pBoy''s Yet Another FTP ' +
                                  'Client > Error', MB_OK + MB_ICONERROR);
    { refresh browser }
        FTPFTools.RefreshLocalBrowser;
    end;
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.LocalPopupPopup(Sender: TObject);
var enableFileOp: boolean;
    currentItem : TListItem;  { temporary list item }
begin
{ disable unreachable menu items }
    currentItem:= LocalList.ItemFocused;
    enableFileOp:= true;
    if currentItem = nil then
       enableFileOp:= false
    else
       if currentItem.ImageIndex <> iiFile then
          enableFileOp:= false;

{ disable if required or enable if required }
    if enableFileOp then
       FileOpLPM.Enabled:= true
    else
       FileOpLPM.Enabled:= false;
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.RemotePopupPopup(Sender: TObject);
begin
{ disable Refresh if not connected, not logged in, or if we're in a command
  sequence }
    if FTPFTools.ControlConnected and LoggedIn and NOOPTimer.Enabled then
       RefreshRPM.Enabled:= true
    else
       RefreshRPM.Enabled:= false;
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.RemoteListKeyPress(Sender: TObject; var Key: Char);
begin
    if Key = #13 then RemoteListDblClick(Sender);
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.MainWindowHelpMClick(Sender: TObject);
begin
    Application.HelpCommand(HELP_CONTEXT, 9);  { MainWindow topic }
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.GeneralHelpMClick(Sender: TObject);
begin
    Application.HelpCommand(HELP_FINDER, 0);
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.CreditzMClick(Sender: TObject);
begin
    Application.HelpCommand(HELP_CONTEXT, $53);  { Creditz topic }
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.HelpaboutPreferences1Click(Sender: TObject);
begin
    Application.HelpCommand(HELP_CONTEXT, $41);  { Pref|Gen topic }
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.HelponTransfer1Click(Sender: TObject);
begin
    Application.HelpCommand(HELP_CONTEXT, $47);  { Transfer win topic }
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.AppException(Sender: TObject; E: Exception);
const ErrorMsg ='An unexpected exception error occurred. Maybe you have to'#10 +
                'shut down YAFTP if it does not work correctly anymore.'#10+
                'To shut down, press CTRL-ALT-DEL, select'#10 +
                'task "pBoy''s Yet Another FTP Client" and close it.'#10#10 +
                'To fix the bug in the program, please report the exact'#10 +
                'circumstances (version of Windows you run, operations you'#10 +
                'have done before the error occurred, remote site address,'#10 +
                'exception message and all informations you think to be'#10 +
                'be important for fix the bug).'#10#10+
                'Send bug reports to petkarsai@iname.com.'#10#10+
                'Don''t forget to include this exception message, '#10+
                'it may be important for me to fixing the bug:'#10#10'"%s".';
begin
{ show standard and exception message }
    Application.MessageBox(PChar(Format(ErrorMsg, [E.Message])),
                           'YAFTP Exception error', MB_OK + MB_ICONEXCLAMATION);
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.RunFileLPMClick(Sender: TObject);
begin
{ do Open }
    FTPFTools.ShellExec('open', GetCurrentDir + '\' +
                        LocalList.ItemFocused.Caption);
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.PrintFileLPMClick(Sender: TObject);
begin
{ do Print }
    FTPFTools.ShellExec('print', GetCurrentDir + '\' +
                        LocalList.ItemFocused.Caption);
end;

{------------------------------------------------------------------------------}

procedure TFTPForm.StartExplorerLPMClick(Sender: TObject);
begin
{ start Exploiter }
    FTPFTools.ShellExec('explore', GetCurrentDir);
end;

end.
